/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.entity.block;

import com.nhoryzon.mc.farmersdelight.FarmersDelightMod;
import com.nhoryzon.mc.farmersdelight.advancement.CuttingBoardTrigger;
import com.nhoryzon.mc.farmersdelight.block.CuttingBoardBlock;
import com.nhoryzon.mc.farmersdelight.item.inventory.ItemHandler;
import com.nhoryzon.mc.farmersdelight.item.inventory.ItemStackHandler;
import com.nhoryzon.mc.farmersdelight.item.inventory.RecipeWrapper;
import com.nhoryzon.mc.farmersdelight.recipe.CuttingBoardRecipe;
import com.nhoryzon.mc.farmersdelight.registry.AdvancementsRegistry;
import com.nhoryzon.mc.farmersdelight.registry.BlockEntityTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.RecipeTypesRegistry;
import com.nhoryzon.mc.farmersdelight.registry.SoundsRegistry;
import com.nhoryzon.mc.farmersdelight.tag.Tags;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class CuttingBoardBlockEntity
extends class_2586 {
    public static final String TAG_KEY_IS_ITEM_CARVED = "IsItemCarved";
    private boolean isItemCarvingBoard;
    private final ItemStackHandler itemHandler = new ItemStackHandler(){

        @Override
        public int getMaxCountForSlot(int slot) {
            return 1;
        }

        @Override
        protected void onInventorySlotChanged(int slot) {
            CuttingBoardBlockEntity.this.inventoryChanged();
        }
    };
    protected final class_3956<? extends CuttingBoardRecipe> recipeType;

    protected CuttingBoardBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState, class_3956<? extends CuttingBoardRecipe> recipeType) {
        super(blockEntityType, blockPos, blockState);
        this.recipeType = recipeType;
        this.isItemCarvingBoard = false;
    }

    public CuttingBoardBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(BlockEntityTypesRegistry.CUTTING_BOARD.get(), blockPos, blockState, RecipeTypesRegistry.CUTTING_RECIPE_SERIALIZER.type());
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.isItemCarvingBoard = tag.method_10577(TAG_KEY_IS_ITEM_CARVED);
        this.itemHandler.fromTag(tag.method_10562("Inventory"));
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566("Inventory", (class_2520)this.itemHandler.toTag());
        tag.method_10556(TAG_KEY_IS_ITEM_CARVED, this.isItemCarvingBoard);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10566("Inventory", (class_2520)this.itemHandler.toTag());
        return nbtCompound;
    }

    public boolean processItemUsingTool(class_1799 tool, class_1657 player) {
        List recipeList = Objects.requireNonNull(this.field_11863).method_8433().method_17877(this.recipeType, (class_1263)new RecipeWrapper(this.itemHandler), this.field_11863);
        CuttingBoardRecipe recipe = recipeList.stream().filter(cuttingRecipe -> cuttingRecipe.getTool().method_8093(tool)).findAny().orElse(null);
        if (player != null) {
            if (recipeList.isEmpty()) {
                player.method_7353((class_2561)FarmersDelightMod.i18n("block.cutting_board.invalid_item", new Object[0]), true);
            } else if (recipe == null) {
                player.method_7353((class_2561)FarmersDelightMod.i18n("block.cutting_board.invalid_tool", new Object[0]), true);
            }
        }
        if (recipe != null) {
            class_2371<class_1799> results = recipe.getResultList();
            for (class_1799 result : results) {
                class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)CuttingBoardBlock.FACING)).method_10160();
                class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.2, (double)this.field_11867.method_10264() + 0.2, (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.2, result.method_7972());
                entity.method_18800((double)((float)direction.method_10148() * 0.2f), 0.0, (double)((float)direction.method_10165() * 0.2f));
                this.field_11863.method_8649((class_1297)entity);
            }
            if (player != null) {
                tool.method_7956(1, (class_1309)player, user -> user.method_20236(class_1268.field_5808));
            } else if (tool.method_7970(1, this.field_11863.method_8409(), null)) {
                tool.method_7939(0);
            }
            this.playProcessingSound(recipe.getSoundEvent(), tool.method_7909(), this.getStoredItem().method_7909());
            this.removeItem();
            this.inventoryChanged();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ((CuttingBoardTrigger)AdvancementsRegistry.CUTTING_BOARD.get()).trigger(serverPlayer);
            }
            return true;
        }
        return false;
    }

    public void playProcessingSound(String soundEventID, class_1792 tool, class_1792 boardItem) {
        class_3414 sound = (class_3414)class_2378.field_11156.method_10223(new class_2960(soundEventID));
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool instanceof class_1820) {
            this.playSound(class_3417.field_14975, 1.0f, 1.0f);
        } else if (tool.method_7854().method_31573(Tags.KNIVES)) {
            this.playSound(SoundsRegistry.BLOCK_CUTTING_BOARD_KNIFE.get(), 0.8f, 1.0f);
        } else if (boardItem instanceof class_1747) {
            class_1747 boardBlockItem = (class_1747)boardItem;
            class_2248 block = boardBlockItem.method_7711();
            class_2498 soundType = block.method_9564().method_26231();
            this.playSound(soundType.method_10595(), 1.0f, 0.8f);
        } else {
            this.playSound(class_3417.field_15215, 1.0f, 0.8f);
        }
    }

    public void playSound(class_3414 sound, float volume, float pitch) {
        Objects.requireNonNull(this.field_11863).method_8465(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
    }

    public boolean carveToolOnBoard(class_1799 tool) {
        if (this.addItem(tool)) {
            this.isItemCarvingBoard = true;
            return true;
        }
        return false;
    }

    public boolean getIsItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    public ItemHandler getInventory() {
        return this.itemHandler;
    }

    public boolean isEmpty() {
        return this.itemHandler.method_5438(0).method_7960();
    }

    public class_1799 getStoredItem() {
        return this.itemHandler.method_5438(0);
    }

    public boolean addItem(class_1799 itemStack) {
        if (this.isEmpty() && !itemStack.method_7960()) {
            this.itemHandler.method_5447(0, itemStack.method_7971(1));
            this.isItemCarvingBoard = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public class_1799 removeItem() {
        if (!this.isEmpty()) {
            this.isItemCarvingBoard = false;
            class_1799 item = this.getStoredItem().method_7971(1);
            this.inventoryChanged();
            return item;
        }
        return class_1799.field_8037;
    }

    private void inventoryChanged() {
        this.method_5431();
        Objects.requireNonNull(this.field_11863).method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }
}

